{$A+,B-,D+,E+,F-,G-,I-,L-,N-,O-,R-,S-,V-,X+}
Program KareltimaIII;

Uses NewDelay,CRT,DOS,Basic,DataEntr,KarObj,KarScn;

Const
  ColorSeg  = $B800;
  MonoSeg   = $B000;
  HexDigits : String [16] = '123456789ABCDEF';
  MaxChr  = 24;
  MaxObj  = 7;
  MaxBlah = 232;

  Sol = 196;     La = 220;     Si = 247;     Doh = 261;    Re = 294;

  stInstr : Array [0..3] Of String [80] = (
    'Umm.. I''d like the instructions, my good man.',
    'Hand me the instructions, lad!',
    'Gimme the instructions, scum, and keep your tongue to yourself. Bliarch!',
    'Show me the instructions or I''l make ear-rings out of your balls!');
  stPlay : Array [0..3] Of String [80] = (
    'Right... So... I think I''ll give it a try...',
    'I know how to play the bleedin'' game, so MOVE it!',
    'Machmooga! Play! Play! Play!',
    'I''m here to play, so I''l play, and I''l play NOW, orc-face!');
  stOk : Array [0..6] Of String [80] = (
    'Right over, o goodly and honourable sir knight! (slurp slurp)',
    'Thy wish is my command, dear sir.',
    'As you wish!',
    'You''re the boss, do as you please.',
    'Do it yourself, you fucking idiot, you bleeding moronic cretin!',
    'What? So that''s what you want to do. I couldn''t care less!',
    'I think you''ll have a better time if you just go and kill yourself.');
  stName : Array [0..3] Of String [80] = (
    'By what name art thou called, o brave sir knight?',
    'What is your name, dear sir?',
    'What would your name be, o brave adventurer?',
    'What be thy name, sir?');
  stCallU : Array [0..5] Of String [80] = (
    'Hmm... That COULD cause a bit of confusion. Mind if I call you ''Stupid''?',
    'Hey, nice name you have there, although I''ll not be using it anywhere.',
    'I can''t remember all that! Nah... let''s just forget this name thing.',
    'My, my, what a horrible name. I''ll just call ya ''Idiot''. OK?',
    'Your name is so ugly I propose we just skip this whole business.',
    'I couldn''t care less!');
   stNoLook : Array [0..3] Of String [80] = (
     'You blind or something? There''s nothing there!',
     '  ⥘...  ⮜ 姦  !',
     ' , *** 婘;  夘 姦 !',
     'You see absolutely nothing.');
   stNoObjs : Array [0..4] Of String [40] = (
     'Nottin''', 'Emptiness', 'Nothing',
     'Your head (not much of a load)', '姦, 婘 娞');
   stNotGotIt : Array [0..3] Of String [80] = (
     'You don''t have that!',
     'You on drugs or something? You don''t have that!',
     '  ᡠ ... ૜⤦ 婘;     !',
     '磘    埠.');

Type
  PScreen = ^TScreen;
  TScreen = Array [0..3999] Of Byte;
  PChr    = ^TChr;
  TChr    = Record
    Symbol : Byte;
    Attr   : Byte;
    X, Y   : Byte;
    Map    : Byte;
    Flags  : Byte;
    Descr  : String [32];
  End;
  PNPCs = ^TNPCs;
  TNPCs = Array [1..MaxChr] Of TChr;
  POBJs = ^TOBJs;
  TOBJs = Array [1..MaxObj] Of TChr;

  PBlah = ^TBlah;
  TBlah = Record
    Chr     : Byte;
    Keyword : String [4];
    Reply   : String [200];
    Event   : Word;
  End;
  PXAct = ^TXAct;
  TXAct = Array [1..240] Of TBlah;


Var
  VideoSeg : Word;
  Lines    : Byte;
  LastX    : Byte;
  PC       : TChr;
  NPCs     : PNPCs;
  XAct     : PXact;
  OBJs     : POBJs;



Procedure NewLine;

Var N : Byte;

Begin
  Inc (Lines);
  If (Lines>=5) Then Begin
    N:=TextAttr;
    TextAttr:=$F0;
    Write(#32#17#196#217#32);
    GetKey;
    Lines:=0;
    GotoXY (1,WhereY);
    TextAttr:=N;
    ClrEOL;
  End;
End;



Procedure Display (S:String);

Var N : Byte;

Begin
  TextColor (White);
  While (S<>'') Do Begin
    If (S [1]=' ') And (WhereX=1) Then Repeat Delete (S,1,1) Until S[1]<>' ';
    If (S [1]='_') Then Begin
      Delete (S,1,1);
      Writeln;
      NewLine;
    End Else If S [1]<>'^' Then Begin
      If ((WhereX + Pos (' ',S))>50)
       Or ((Pos (' ',S)=0) And (WhereX+Length(S)>50)) Then Begin
        Writeln;
        NewLine;
      End;
      Write(S[1]);
      If WhereX=1 Then NewLine;
      Delete (S,1,1);
    End Else Begin
      Delete (S,1,1);
      TextColor (Pos (UpCase(S[1]), HexDigits));
      Delete (S,1,1);
    End;
  End;
End;


Procedure MainWindow (B:PScreen);

Var
  N : Byte;
  I : Word;
  J : Word;
  P : Pointer;

Begin
  If VideoSeg=MonoSeg Then For I:=0 To 1109 Do B^ [I*2+1]:=$0F;
  I:=$A6;
  J:=0;
  P:=Ptr(VideoSeg,I);
  For N:=0 To 14 Do Begin
    Move (B^ [J], P^, 148);
    Inc (J, 148);
    Inc (I, 160);
    P:=Ptr(VideoSeg,I);
  End;
End;


Procedure JumpOnTheKeyboard (N:Byte);

Var I : Byte;

Begin
  For I:=1 To N Do Begin
    GetKey;
    Lines:=0;
    Sound (100+I*5);
    Delay (30);
    NoSound;
  End;
  Sound (500);
  Delay (40);
  NoSound;
End;


Procedure HaltProc;

Begin
  Window (1,1,80,25);
  TextAttr:=$07;
  ClrScr;
  Writeln ('Thank you for playing Kareltima III.');
  Writeln ('Have a nice day, and next time be more careful.');
  Writeln ('Weird programs may turn what''s left of your brains into oatmeal.');
  Writeln;
  Writeln;
  Halt;
End;


Procedure Prepare;

Begin
  Randomize;
  If LastMode=7 Then VideoSeg:=MonoSeg Else VideoSeg:=ColorSeg;
  Lines:=0;
  ExitProc:=@HaltProc;
  NPCs:=@_NPCS_DAT;
  XAct:=@_XACT_DAT;
  OBJs:=@_OBJ_DAT;
  SetCBreak (False);
  ClrScr;
End;


Procedure DisplayMainScreen;

Var
  B : ^TScreen;
  N : Word;
  P : Pointer;

Begin
  B:=@_MAIN_SCN;
  P:=Ptr (VideoSeg,0);
  If VideoSeg=MonoSeg Then For N:=0 To 1999 Do B^ [N*2+1]:=$0F;
  Move (B^, P^, 4000);
End;


Procedure Welcome;

Var
  Key : Word;
  N   : Word;
  Ok  : Boolean;

Begin
  Window (5,18,52,23);
  ClrScr;
  Display ('^FGreetings, good sire! Please press <^AI^F> for instructions, ');
  Display ('<^AP^F> to play, or <^AEsc^F> to quit._');
  Repeat
    Key:=GetKey;
    Lines:=0;
    Ok:=False;
    If (Key=73) Or (Key=105) Then Begin
      Display('^7'+stInstr[Random(4)]+'_');
      Display('^F'+stOk[Random(7)]+'_');
      MainWindow (@_INSTR1_SCN);
      JumpOnTheKeyboard(15);
      MainWindow (@_INSTR2_SCN);
      JumpOnTheKeyboard(30);
      MainWindow (@_INSTR3_SCN);
      JumpOnTheKeyboard(45);
      MainWindow (@_INSTR4_SCN);
      Delay (500);
      GetKey;
      Sound (700);
      Delay (30);
      NoSound;
      DisplayMainScreen;
      Ok:=False;
      Window (5,18,52,23);
      ClrScr;
      Display ('^FGreetings, good sire! Please press <^AI^F> for instructions, ');
      Display ('<^AP^F> to play, or <^AEsc^F> to quit._');
    End Else If (Key=80) Or (Key=112) Then Begin
      Display ('^7'+stPlay[Random(4)]+'_');
      Display('^F'+stOk[Random(7)]+'_');
      Ok:=True;
    End Else If (Key=27) Then Halt Else Begin
      For N:=150 DownTo 100 Do Begin
        Sound (N);
        Delay (2);
      End;
      NoSound;
    End;
  Until Ok;
End;


Procedure AskName;

Var
  W : Word;
  S : String;

Begin
  Display ('_^F'+stName[Random(4)]+'_^7');
  S:='';
  Lines:=0;
  LastX:=WhereX;
  Repeat
    Get_String (1,40,All,W,S);
    GotoXY (LastX,WhereY);
  Until W=13;
  Display ('_^F'+stCallU[Random(6)]+'___');
End;


Procedure DrawChr (N : TChr);

Var
  Color : Byte;
  Addr  : Word;

Begin
  With N Do Begin
    Addr:=$A6 + ((X-1) * 2) + ((Y-1) * 160);
    If VideoSeg=MonoSeg Then Color:=$07 Else Begin
      Color:=(Mem [VideoSeg:(Addr+1)] And $F0) Or Attr;
    End;
    MemW [VideoSeg:Addr]:=Symbol Or (Color Shl 8);
  End;
End;



Function MoveChr (Var N:TChr; DX, DY: Integer): Boolean;

Var
  Color  : Byte;
  Addr   : Word;
  Target : Word;

Begin
  With N Do Begin
    If (X=1) And (DX=-1) Then DX:=0;
    If (X=74) And (DX=1) Then DX:=0;
    If (Y=1) And (DY=-1) Then DY:=0;
    If (Y=15) And (DY=1) Then DY:=0;
    If (DX=0) And (DY=0) Then Begin
      MoveChr:=False;
      Exit;
    End;
    Target:=$A6 + ((X+DX-1) * 2) + ((Y+DY-1) * 160);
    If Mem [VideoSeg:Target] <> $20 Then Begin
      MoveChr:=False;
      Exit;
    End;
    Addr:=$A6 + ((X-1) * 2) + ((Y-1) * 160);
    If VideoSeg=MonoSeg Then Color:=$0F Else Begin
      Color:=(Mem [VideoSeg:(Addr+1)] And $F0);
    End;
    MemW [VideoSeg:Addr]:=$20 Or (Color Shl 8);
    Inc (X,DX);
    Inc (Y,DY);
    MoveChr:=True;
    DrawChr (N);
  End;
End;



Procedure DisplayMap (N:Byte);

Var I : Byte;

Begin
  Case N Of
    1: MainWindow (@_MAP1_SCN);
    2: MainWindow (@_MAP2_SCN);
    3: MainWindow (@_MAP3_SCN);
    4: MainWindow (@_MAP4_SCN);
  End;
  For I:=1 To MaxChr Do With NPCs^ [I] Do If Map = N Then DrawChr (NPCs^ [I]);
  For I:=1 To MaxObj Do With OBJs^ [I] Do If Map = N Then DrawChr (OBJs^ [I]);
  DrawChr (PC);
End;



Procedure NewMap (M,X,Y:Word);

Begin
  PC.Map:=M;
  PC.X:=X;
  PC.Y:=Y;
  DisplayMap (M);
End;



Procedure MoveNPCs;

Var
  D : Word;
  I : Byte;
  A : Integer;
  B : Integer;

Begin
  For I:=1 To MaxChr Do With NPCs^ [I] Do If (Map = PC.Map) And (Flags=0) Then Begin
    D:=Random (6);
    A:=0;
    B:=0;
    Case D Of
      1: A:=1;
      2: A:=-1;
      3: B:=1;
      4: B:=-1;
    End;
    MoveChr (NPCs^ [I], A, B);
  End;
End;



Procedure MovePC (DX,DY:Integer);

Var
  R : Boolean;
  I : Byte;

Begin
  MoveNPCs;
  R:=MoveChr (PC,DX,DY);
  If Not R Then With PC Do Begin
    If ((X=1) And (DX=-1)) Or ((X=74) And (DX=1))
     Or ((Y=1) And (DY=-1)) Or ((Y=15) And (DY=1)) Then Begin
      R:=True;
      If (Map=1) And (Y=1) Then NewMap (2,X,15)
      Else If (Map=1) And (Y=15) Then NewMap (3,X,1)
      Else If (Map=1) And (X=1) Then NewMap (4,74,Y)
      Else If (Map=2) And (Y=15) Then NewMap (1,X,1)
      Else If (Map=3) And (Y=1) Then NewMap (1,X,15)
      Else If (Map=4) And (X=74) Then NewMap (1,1,Y)
      Else R:=False;
    End;
  End;

  If Not R Then Begin
    Display ('^CBlocked!_');
    Sound (4000);
    Delay (50);
    NoSound;
  End Else Begin
    If (DY=-1) Then Display ('^ENorth_');
    If (DY=1) Then Display ('^ESouth_');
    If (DX=-1) Then Display ('^EWest_');
    If (DX=1) Then Display ('^EEast_');
    Sound (50);
    Delay (50);
    NoSound;
  End;
End;



Function GetShiftState: Byte;

Var Regs : Registers;

Begin
  Regs.AH:=$02;
  Intr ($16,Regs);
  GetShiftState := Regs.AL;
End;



Procedure AskDir (Var DX, DY: Integer);

Var
  Ok : Boolean;
  K  : Word;

Begin
  Repeat
    Ok:=True;
    K:=GetKey;
    Case K Of
      UpArrow, 56    : Begin   DX:=0;   DY:=-1;  Display (#8'^ENorth_');  End;
      DnArrow, 50    : Begin   DX:=0;   DY:=1;   Display (#8'^ESouth_');  End;
      LeftArrow, 52  : Begin   DX:=-1;  DY:=0;   Display (#8'^EWest_');   End;
      RightArrow, 54 : Begin   DX:=1;   DY:=0;   Display (#8'^EEast_');   End;
      Else Begin
        Ok:=False;
        For K:=150 DownTo 100 Do Begin
          Sound (K);
          Delay (2);
        End;
        NoSound;
      End;
    End;
  Until Ok;
End;



Procedure Look;

Var
  DX : Integer;
  DY : Integer;
  K  : Word;

Begin
  Display ('^DLook - ?');
  AskDir (DX,DY);
  For K:=1 To MaxChr Do With NPCs^ [K] Do Begin
    If (Map=PC.Map) And (X=PC.X+DX) And (Y=PC.Y+DY) Then Begin
      Display ('^FYou see a'+Descr+'._');
      Exit;
    End;
  End;
  For K:=1 To MaxOBJ Do With OBJs^ [K] Do Begin
    If (Map=PC.Map) And (X=PC.X+DX) And (Y=PC.Y+DY) Then Begin
      Display ('^FYou see a'+Descr+'._');
      Exit;
    End;
  End;
  Display ('^F'+stNoLook[Random(4)]+'_');
End;



Procedure Search;

Var
  DX : Integer;
  DY : Integer;
  K  : Word;

Begin
  Display ('^DSearch - ?');
  AskDir (DX,DY);
  For K:=1 To MaxOBJ Do With OBJs^ [K] Do Begin
    If (Map=PC.Map) And (X=PC.X+DX) And (Y=PC.Y+DY) Then Begin
      Display ('^FYou see a'+Descr+'._');
      Exit;
    End;
  End;
  Display ('^F'+stNoLook[Random(4)]+'_');
End;



Procedure Note (Freq, Dur: Word; S:String);

Begin
  Lines:=0;
  Display ('^D'+S);
  Sound (Freq);
  Delay (Dur Div 4 * 3);
  NoSound;
  Delay (Dur Div 4);
End;



Procedure Pumaro;

Var I: Word;

Begin
  Note (Sol,200,''' ');   Note (Doh,200,'');     Note (Doh,200,' ');
  Note (Doh,200,' ');    Note (Doh,200,'');     Note (La,400,' ');
  Delay (200);
  Note (Si,200,'');       Note (Doh,200,'');     Note (Re,200,'');
  Note (Si,200,'');       Note (Doh,400,', ');
  Delay (400);
  Note (Doh,200,'Pu');      Note (Doh,200,'ma');     Note (Doh,400,'ro, ');
  Note (La,200,'Pu');       Note (La,200,'ma');      Note (La,400,'ro, ');
  Note (Si,200,'Pu');       Note (Doh,200,'ma- ');   Note (Re,200,'Pu');
  Note (Si,200,'ma');       Note (Doh,400,'ro!_');
  Delay (500);
  Note (Doh,600,'皡, ');
  Note (Si,600,'皡, ');
  Note (La,600,'皡, ');
  Note (Re,200,'');
  Note (Doh,300,' ');
  Note (Doh,600,' ');
  Note (La,150,'');
  Note (Si,200,'_');
  Note (La,200,'');
  Note (Doh,200,'');
  Note (Re,600,'');
  For I:=(Re Div 10) DownTo 5 Do Note (I*10,50,'');
  Note (50,150,'.');
End;



Procedure EndTheGame;

Var
  B : ^TScreen;
  N : Word;
  P : Pointer;

Begin
  For N:=35 To 70 Do Begin
    Sound (N*10);
    Delay (5);
  End;
  NoSound;
  Delay (4000);
  Window (1,1,80,25);
  ClrScr;
  While KeyPressed Do ReadKey;
  B:=@_END_SCN;
  P:=Ptr (VideoSeg,0);
  If VideoSeg=MonoSeg Then For N:=0 To 1999 Do B^ [N*2+1]:=$0F;
  Move (B^, P^, 4000);
  For N:=70 To 140 Do Begin
    Sound (N*10);
    Delay (10);
  End;
  NoSound;
  ReadKey;
  Halt;
End;



Procedure Blah (Chr:Byte; KW:String); Forward;



Procedure HandleEvent (Event:Word);

Begin
  Case Event Of
    1:Begin
        If (OBJs^ [1].Map=0) And (OBJs^ [2].Map=255) Then Begin
          Display ('Okeedokee, Mr. So-and-so, here''s your drink._');
          Display ('^A[Gives you a bottle of Rum]_');
          OBJs^ [2].Map:=0;
        End Else If (OBJs^ [1].Map=0) And (OBJs^ [2].Map<>255) Then Begin
          Display ('You already have a bottle. I can''t give you ');
          Display ('another till you drink that! It could ');
          Display ('cause drink inflation!_');
        End Else If (OBJs^ [1].Map<>0) Then Begin
          Display ('That''s not an ID! Get an ID, and I''ll give you drink._');
        End;
      End;
    2:Begin
        If (OBJs^ [1].Map<>255) Then Begin
          Display ('Hrumpff... Vere ist my ID? I don''t reb- remb- remembah ');
          Display ('drinking it!_');
        End Else Begin
          Display ('^A[Gives you a fake ID]_');
          OBJs^ [1].Map:=0;
        End;
      End;
    3:Begin
        If (OBJs^ [3].Map<>255) Then Begin
          Display ('Oh, by the way, did you have my ring fixed?_');
        End Else Begin
          Display ('Right! You got me into this mess, you''ll have to '+
                   'get me out. Take your silly ring and have it fixed. '+
                   'And, in the meantime, get me another nice toy._'
          );
          Display ('^A[Gives you a singing ring]_');
          OBJs^ [3].Map:=0;
        End;
      End;
    4:Begin
        If (OBJs^ [3].Map=0) Or (OBJs^ [3].Map=255) Then Begin
          Display ('Listen to it!_^A[The ring starts singing]__');
          Delay (1000);
          Pumaro;
          Display ('__');
        End Else Begin
          Display ('If we had the ring here, I''d have it sing._');
        End;
      End;
    5:Begin
        If (OBJs^ [3].Map=0) Then Begin
          Display ('Let''s have a look at that ring... ');
          Blah (11,#4);
        End Else Begin
          Display ('Yes, good sir. It is almost impossible for our rings '+
                   'to malfunction in any way. IF, however, although it''s '+
                   'almost impossible, you own a defective ring, bring it '+
                   'to us and we''ll have it serviced for free!_'
          );
        End;
      End;
    6:Begin
        If (OBJs^ [2].Map=0) Then Begin
          Display ('Hey, that a present for me? Wow! ''Ram'' Rum! Thanks '+
                   'gov''nor!_^A[Grabs the bottle of rum and drinks]_');
          OBJs^ [2].Map:=255;
        End;
      End;
    7:Begin
        If (OBJs^ [4].Map=255) Then Begin
          Display ('^A[Gives you an egg]_');
          OBJs^ [4].Map:=0;
        End;
      End;
    8:Begin
        If (OBJs^ [3].Map=0) Then Begin
          Blah (24,#5);
          Display ('^A[Takes the singing ring]_');
          OBJs^ [3].Map:=254;
        End Else Begin
          Blah (24,#4);
        End;
      End;
    9:Begin
        If (OBJs^ [3].Map<>254) Then Begin
          Display ('What egg?_');
        End Else If (OBJs^ [4].Map=0) Then Begin
          Display ('Ooh, me egg! Thanks! _^A[Takes the egg and eats it]^F_ '+
                   'Yummy! I''ll fix yer ring now. It''ll be ready by '+
                   'Kareltima IV._');
          OBJs^ [4].Map:=254;
        End Else If (OBJs^ [4].Map=254) Then Begin
          Display ('Nice egg, too! Pity I didn''t have no salt on me._');
        End Else Begin
          Display ('Yeh, I needs the bloody egg. Important tool, it is._');
        End;
      End;
    10:Begin
        If (OBJs^ [5].Map=255) Then Begin
          Blah (18,#4);
          Display ('^A[Gives you a piece of smelly cheese]_');
          OBJs^ [5].Map:=0;
        End Else Blah (18,#5);
      End;
    11:Begin
        If (OBJs^ [5].Map=0) Then Begin
          Blah (23,#4);
          OBJs^ [5].Map:=254;
        End;
      End;
    12:Begin
        If (OBJs^ [6].Map=255) Then Begin
          Display ('Here you go! _^A[Gives you a shrubbery]_');
          OBJs^ [6].Map:=0;
        End Else Begin
          Display ('Yes, like the one I gave you earlier._');
        End;
      End;
    13:Begin
        If (OBJs^ [7].Map=255) And (OBJs^ [6].Map=0) Then Begin
          Blah (21,#4);
          Display ('^A[Gives you the Self-Beating Machine]_');
          OBJs^ [7].Map:=0;
          OBJs^ [6].Map:=254;
        End Else Display ('Stay right there!_');
      End;
    14:Begin
        If (OBJs^ [7].Map=0) Then Begin
          Display ('Oh! Another nice present for me? Goody!_');
          Display ('^A[Takes the Self-Beating Machine]_');
          OBJs^ [7].Map:=255;
          EndTheGame;
        End Else Blah (5,#4);
      End;
  End;
End;



Procedure Blah (Chr:Byte; KW:String);

Var K : Word;

Begin
  For K:=1 To MaxBlah Do Begin
    If (XAct^ [K].Chr=Chr) And (XAct^ [K].Keyword=KW) Then Begin
      If (XAct^ [K].Reply<>'') Then Display ('^F'+Xact^ [K].Reply+'_');
      If (XAct^ [K].Event<>0) Then HandleEvent (Xact^ [K].Event);
      Exit;
    End;
  End;
  If KW=#2 Then Halt(1);
  Blah (Chr, #2);
End;



Procedure Talk;

Var
  DX   : Integer;
  DY   : Integer;
  K, W : Word;
  Key  : String;

Begin
  Display ('^DTalk - ?');
  AskDir (DX,DY);
  For K:=1 To MaxChr Do With NPCs^ [K] Do Begin
    If (Map=PC.Map) And (X=PC.X+DX) And (Y=PC.Y+DY) Then Begin
      Display ('^CYou encounter a'+Descr+'._');
      Blah (K,#1);
      Repeat
        Display (':^7');
        Key:='';
        Lines:=0;
        LastX:=WhereX;
        Repeat
          Get_String (0,40,All,W,Key);
          GotoXY (LastX,WhereY);
        Until W=13;
        Key:=UpperCase (Key);
        Key:=Copy (Key,1,4);
        Display ('_');
        If (Key='') Or (Key='BYE') Then Key:=#3;
        Blah (K,Key);
      Until Key=#3;
      Exit;
    End;
  End;
  Display ('^F'+stNoLook[Random(4)]+'_');
End;



Procedure Inventory;

Var
  I, J : Word;
  S    : String [5];

Begin
  Display ('_You are carrying:_');
  J:=0;
  For I:=1 To MaxObj Do With OBJs^ [I] Do Begin
    If Map=0 Then Begin
      Inc (J);
      S:=WToS (J);
      Display ('^B'#255' ('+S+'). A'+Descr+'_');
    End;
  End;
  If (J=0) Then Display ('^B'#255'  '+stNoObjs[Random (5)]+'_');
End;



Procedure Drop;

Var
  I, J, K : Word;
  Target  : Word;
  DX, DY  : Integer;
  S       : String [5];
  Ok      : Boolean;

Begin
  Display ('_(DROP) You are carrying:_');
  J:=0;
  For I:=1 To MaxObj Do With OBJs^ [I] Do Begin
    If Map=0 Then Begin
      Inc (J);
      S:=WToS (J);
      Display ('^B'#255' ('+S+'). A'+Descr+'_');
    End;
  End;
  If (J=0) Then Begin
    Display ('^B'#255'  '+stNoObjs[Random (5)]+'_');
    Exit;
  End;
  Display ('^DDrop what item? ^7');
  S:='';
  Lines:=0;
  LastX:=WhereX;
  Repeat
    Get_String (0,2,Numbers,I,S);
    GotoXY (LastX,WhereY);
  Until I=13;
  If S='' Then Begin
    Display ('_');
    Exit;
  End;
  J:=SToW (S);
  I:=1;
  K:=1;
  Ok:=False;
  While (I<=MaxObj) And Not Ok Do With OBJs^ [I] Do Begin
    If Map=0 Then Begin
      Ok:=K=J;
      Inc (K);
    End;
    Inc (I);
  End;
  If Not Ok Then Begin
    Display ('_^F'+stNotGotIt[Random(4)]+'_');
    Exit;
  End;
  Dec (I);
  Display ('_^DDrop a'+OBJs^ [I].Descr+'_Where - ?');
  AskDir (DX,DY);
  Target:=$A6 + ((PC.X+DX-1) * 2) + ((PC.Y+DY-1) * 160);
  If Mem [VideoSeg:Target] <> $20 Then Begin
    Display ('^CNo room!_');
    Exit;
  End;
  With OBJs^ [I] Do Begin
    X:=PC.X+DX;
    Y:=PC.Y+DY;
    Map:=PC.Map;
  End;
  DrawChr (OBJs^ [I]);
End;



Procedure Use;

Var
  I, J, K : Word;
  Ok      : Boolean;
  S       : String;

Begin
  Display ('_(USE) You are carrying:_');
  J:=0;
  For I:=1 To MaxObj Do With OBJs^ [I] Do Begin
    If Map=0 Then Begin
      Inc (J);
      S:=WToS (J);
      Display ('^B'#255' ('+S+'). A'+Descr+'_');
    End;
  End;
  If (J=0) Then Begin
    Display ('^B'#255'  '+stNoObjs[Random (5)]+'_');
    Exit;
  End;
  Display ('^DUse what item? ^7');
  S:='';
  Lines:=0;
  LastX:=WhereX;
  Repeat
    Get_String (0,2,Numbers,I,S);
    GotoXY (LastX,WhereY);
  Until I=13;
  If S='' Then Begin
    Display ('_');
    Exit;
  End;
  J:=SToW (S);
  I:=1;
  K:=1;
  Ok:=False;
  While (I<=MaxObj) And Not Ok Do With OBJs^ [I] Do Begin
    If Map=0 Then Begin
      Ok:=K=J;
      Inc (K);
    End;
    Inc (I);
  End;
  If Not Ok Then Begin
    Display ('_^F'+stNotGotIt[Random(4)]+'_');
    Exit;
  End;
  Dec (I);
  Display ('_');
  Case I Of
    1:Begin
        Display ('You can only use an ID card to open doors, and there are '+
                 'no doors around._'
        );
      End;
    2:Begin
        Display ('^A[You drink the rum]_');
        OBJs^ [2].Map:=255;
      End;
    3:Begin
        Display ('All right, so you wear the ring on a toe and wait. '+
                 'You obviously lack the elementary intelligence to '+
                 'use it._'
        );
      End;
    4:Begin
        Display ('^A[You eat the egg]_');
        OBJs^ [4].Map:=255;
      End;
    5:Display ('You don''t really want to eat THAT!_');
    6:Display ('What, eat a shrubbery? You gotta be kidding!_');
    7:Begin
        Display ('The machine is very amused by your futile efforts to '+
                 'start it._'
        );
      End;
  End;
End;



Procedure Get;

Var
  DX, DY : Integer;
  Target : Word;
  I      : Word;

Begin
  Display ('^DGet - ?');
  AskDir (DX,DY);
  Inc (DX,PC.X);
  Inc (DY,PC.Y);
  For I:=1 To MaxObj Do With OBJs^ [I] Do Begin
    If (Map = PC.Map) And (X=DX) And (Y=DY) Then Begin
      Target:=$A6 + ((DX-1) * 2) + ((DY-1) * 160);
      Mem [VideoSeg:Target]:=$20;
      Display ('^AOk, you got a'+OBJS^ [I].Descr+'._');
      Map:=0;
      Exit;
    End;
  End;
  Display ('^F'+stNoLook[Random(4)]+'_');
End;



Procedure Quit;

Begin
  Display ('_^CQuit and not save? ');
  Delay (2000);
  Display ('__Oh, I forget; there is no Save option! Oh well, out we go.');
  Delay (2000);
  Halt;
End;



Procedure Play;

Var
  OldState : Byte;
  NewState : Byte;
  Key      : Word;

Begin
  With PC Do Begin
    X:=36;
    Y:=6;
    Map:=1;
    Symbol:=Ord('A');
    Attr:=$0F;
  End;
  DisplayMap (1);
  Display ('^CWarning: ^EDo not press the Ctrl or Alt keys during the game. ');
  Display ('Remember, there''s nothing a desperate program won''t do.__');
  OldState:=GetShiftState And $0C;
  Repeat
    Display ('^FCommand: ');
    Repeat
      Lines:=0;
      NewState:=GetShiftState And $0C;
      If NewState<>OldState Then Begin
        If (OldState=$0C) And (NewState<OldState) Then Begin
          Display ('^CPhew!_^FCommand: ');
          OldState:=NewState;
        End Else Begin
          OldState:=NewState;
          Case NewState Of
            $04: Display ('^CLet go of that Ctrl key! _^FCommand: ');
            $08: Display ('^CDon''t touch that Alt key! _^FCommand: ');
            $0C: Display ('^CNo, no, wait, let''s talk it over! _^FCommand: ');
          End;
        End;
      End;
    Until Keypressed;
    Key:=GetKey;
    Case Key Of
      UpArrow, 56    : MovePC (0,-1);
      DnArrow, 50    : MovePC (0,1);
      LeftArrow, 52  : MovePC (-1,0);
      RightArrow, 54 : MovePC (1,0);
      76, 108        : Look;
      84, 116        : Talk;
      73, 105        : Inventory;
      68, 100        : Drop;
      71, 103        : Get;
      83, 115        : Search;
      85, 117        : Use;
      81, 113        : Quit;
      Else Display ('_');
    End;
    While KeyPressed Do ReadKey;
  Until False;
End;



Begin
  Prepare;
  DisplayMainScreen;
  Welcome;
  AskName;
  Play;
End.
