UNIT DataEntr;

INTERFACE

  TYPE
    AllowString=Set Of CHAR;

  CONST
    MonthLen:Array [1..12] Of BYTE=(31,28,31,30,31,30,31,31,30,31,30,31);

    ALL:AllowString=[#01..#255];
    Alpha:AllowString=['A'..'Z'];
    Lower:AllowString=['a'..'z'];
    Numbers:AllowString=['0'..'9'];
    Symbols:AllowString=['!','$','%','&','/','(',')','=','?','+','*','.',',',':',';'];



  PROCEDURE Get_String(MinLen,MaxLen:BYTE; Allowed_Keys:AllowString; { Procedure to get }
                                    VAR ExitKey:WORD; VAR S:String); { a string         }

  PROCEDURE Get_Date(VAR DD,MM,YY,ExitKey:WORD);         { Procedure to get a date with }
                                                         { validation                   }

  PROCEDURE Set_Password;  { Procedure to notify Get_String that the next input will be }
                           { a password so all characters appear as '*'                 }

  PROCEDURE Reset_Password;



IMPLEMENTATION


  USES Basic,CRT;

  VAR
    Password_Entry:BOOLEAN;


  PROCEDURE Get_String (MinLen,MaxLen:BYTE; Allowed_Keys:AllowString;
                                             VAR ExitKey:WORD; VAR S:String);

    PROCEDURE Display (S:String);             { Subprogram to display current string or }
                                              { asterisks if entering a password.       }
    VAR I:BYTE;

    BEGIN
      If Not Password_Entry Then Begin
        PrintAt (WhereX,WhereY,S+' ',TextAttr);
        Write (S);
      End Else BEGIN
        PrintAt (WhereX,WhereY,OutMany ('*',LENGTH (S))+' ',TextAttr);
        Write (OutMany ('*',Length (S)));
      END;
    END;


  VAR
    CP,X,Y,Len:BYTE;
    Finished:BOOLEAN;

  BEGIN
    Finished:=FALSE;
    X:=WhereX;
    Y:=WhereY;
    If S<>'' THEN CP:=LENGTH(S)+1 ELSE CP:=1;
    Allowed_Keys:=Allowed_Keys + [#13,#8];           { Allow special keys to be pressed }

    GotoXY (X,Y);
    If S<>'' THEN DISPLAY (S);
    GotoXY (X+CP-1,Y);

    While Not Finished Do BEGIN

      ExitKey:=GetKey;                                                { Get a key press }

      If ExitKey>255 Then Case Lo(ExitKey) Of             { Interpret special edit keys }
        Lo(LeftArrow) :If CP>1 Then Dec (CP);
        Lo(RightArrow):If CP<(Length (S)+1) Then Inc (CP);
        Lo(HomeKey)   :CP:=1;
        Lo(EndKey)    :CP:=Length(S)+1;
      Else Finished:=TRUE END;

      If ExitKey<255 Then Case Lo(ExitKey) Of                   { Interpret normal keys }
        9,
        27,
        13:If Length (S)>=MinLen Then Finished:=TRUE;           { Termination keys      }
         8:BEGIN
            Delete (S,CP-1,1);
            If CP>1 Then Dec(CP);
            GotoXY (X,Y);
            Display (S);
            PrintAt (WhereX,WhereY,' ',TextAttr);
            Write (' ');
          END;
        Else If (Length (S)<MaxLen) And (Chr(Lo(ExitKey)) In Allowed_Keys) And
         (ExitKey<=255) Then BEGIN
          Insert (Chr(Lo(ExitKey)),S,CP);
          Inc (CP);
        END;
      END;
      GotoXY (X,Y);
      Display (S);
      GotoXY (X+CP-1,Y);
    END;
    If ExitKey In [Enter,ESC] Then Password_Entry:=FALSE;        { Reset password entry }
  END;



  PROCEDURE Get_Date (VAR DD,MM,YY,ExitKey:WORD);

  VAR
    DDS,MMS     :String [2];
    YYS         :String [4];
    X,Y,Temp,ERR:WORD;
    OK          :BOOLEAN;
    Field       :INTEGER;
    CP          :INTEGER;

  BEGIN
    X:=WhereX;
    Y:=WhereY;
    OK:=FALSE;
    Field:=0;
    CP:=2;
    Str (DD,DDS);
    Str (MM,MMS);
    Str (YY,YYS);
    Repeat
      PrintAt (X,Y,'  ',TEXTATTR);
      PrintAt (X+2-Length(DDS),Y,DDS,TextAttr);
      PrintAt (X+3,Y,'  ',TEXTATTR);
      PrintAt (X+5-Length(MMS),Y,MMS,TextAttr);
      PrintAt (X+6,Y,'    ',TEXTATTR);
      PrintAt (X+10-Length(YYS),Y,YYS,TextAttr);
      GotoXY (X+Field*3+CP,Y);
      ExitKey:=GetKey;
      Case ExitKey Of
        LeftArrow:BEGIN                                                { Interpret keys }
          Dec (Field);
          If Field<0 Then Field:=2;
          If Field<2 Then CP:=2 Else CP:=4;
        END;

        RightArrow:BEGIN
          Inc (Field);
          If Field>2 Then Field:=0;
          If Field<2 Then CP:=2 Else CP:=4;
        END;

        Ord ('0')..ORD ('9'):Case Field Of                                 { Data entry }
          0:BEGIN
            Val (MMS,MM,ERR);
            Val (DDS+Chr(ExitKey),Temp,ERR);
            If (Temp>=1) And ((Temp<=MonthLen [MM]) Or
             ((Temp<=MonthLen [MM]+1) And (MM=2) And (YY Mod 4=0)))
             Then DDS:=DDS+Chr(ExitKey);
          END;
          1:BEGIN
            Val (MMS+Chr(ExitKey),Temp,ERR);
            If (Temp>=1) And (Temp<=12) Then MMS:=MMS+Chr(ExitKey);
          END;
          2:BEGIN
            Val (YYS+Chr(ExitKey),Temp,ERR);
            If (Temp<=2200) Then YYS:=YYS+Chr(ExitKey);
          END;
        END;
        8:Case Field Of                                            { Delete a character }
          0:If DDS<>'' THEN DELETE (DDS,LENGTH (DDS),1);
          1:If MMS<>'' THEN DELETE (MMS,LENGTH (MMS),1);
          2:If YYS<>'' THEN DELETE (YYS,LENGTH (YYS),1);
        END;
      Else If (ExitKey<32) Or (ExitKey>255) Then BEGIN    { Make sure the date is valid }
        Val (DDS,DD,ERR);                                 { before exiting              }
        Val (MMS,MM,ERR);
        Val (YYS,YY,ERR);
        If (DD>0) And ((DD<=MonthLen [MM]) Or ((DD<=MonthLen [MM]+1))
         And (MM=2) And (YY Mod 4=0)) And (MM>0) And (MM<12) And (YY>=1900)
         And (YY<=2200) Then OK:=TRUE Else Bell;        { If the date is invalid, beep. }
      END;
    END;
    Until OK;
  END;



  PROCEDURE Set_Password;

  BEGIN
    Password_Entry:=TRUE;
  END;


  PROCEDURE Reset_Password;

  BEGIN
    Password_Entry:=FALSE;
  END;


BEGIN
  Password_Entry:=FALSE;                                    { Initialize password entry }
END.
