{$A-,B-,D+,E-,F+,I-,L+,N-,O+,R-,S-,V-}
UNIT Basic;                                     { Unit containing simple but important  }
                                                { procedures and functions.             }

INTERFACE

CONST
  HelpKey   =315;
  UpArrow   =328;
  DnArrow   =336;
  LeftArrow =331;
  RightArrow=333;

  CtrlLeft  =371;
  CtrlRight =372;
  CTRL_PgUp =388;
  CTRL_PgDn =374;
  CTRL_F    =6;
  CTRL_U    =21;
  CTRL_B    =2;
  CTRL_N    =14;
  CTRL_O    =15;

  HomeKey=327;
  EndKey =335;

  PgUp=329;
  PgDn=337;

  Enter=13;
  ESC=27;

  ALT_A=286;  ALT_B=304;  ALT_C=302;  ALT_D=288;  ALT_E=274;
  ALT_F=289;  ALT_G=290;  ALT_H=291;  ALT_I=279;  ALT_J=292;
  ALT_K=293;  ALT_L=294;  ALT_M=306;  ALT_N=305;  ALT_O=280;
  ALT_P=281;  ALT_Q=272;  ALT_R=275;  ALT_S=287;  ALT_T=276;
  ALT_U=278;  ALT_V=303;  ALT_W=273;  ALT_X=301;  ALT_Y=277;
  ALT_Z=300;

  ALT_Eq=387;  ALT_Hy=386;

  F1=315;    Alt_F1=360;
  F2=316;    Alt_F2=361;
  F3=317;    Alt_F3=362;
  F4=318;    Alt_F4=363;
  F5=319;    Alt_F5=364;
  F6=320;    Alt_F6=365;
  F7=321;    Alt_F7=366;
  F8=322;    Alt_F8=367;
  F9=323;    Alt_F9=368;
  F10=324;   Alt_F10=369;

  Alt_1=376;  Alt_2=377;  Alt_3=378;  Alt_4=379;


TYPE
  Date=Record
    YY:WORD;
    MM:WORD;
    DD:WORD;
  END;

  SoundRec=Record
    Freq : Word;
    Dur  : Word;
  End;



VAR
  Rows,Columns:BYTE;                            { Number of rows and collumns of screen }
  LastTextMode:BYTE;
  BellSnd,KeyPr:SoundRec;                       { Bell & Keyclick sounds are defined by }
                                                { DURation and FREQuency                }



FUNCTION Max (A,B:LongInt):LongInt;


FUNCTION Min (A,B:LongInt):LongInt;


FUNCTION IToS (N:INTEGER):String;                     { Converts an integer to a string }


FUNCTION WToS (N:WORD):String;                        { Converts a word to a string     }


FUNCTION LToS (N:LONGINT):String;                     { Converts a longint to a string  }


FUNCTION BToS (B:BYTE):String;                        { Converts a byte to a string     }


FUNCTION SToW (S:String):Word;                            { Converts a string to a word }


FUNCTION SToL (S:String):LongInt;                 { Converts a string to a long integer }


FUNCTION GrUpCase (C:Char):Char;                   { Capitalizes a [greek] character    }


FUNCTION LCase (C:Char):Char;


FUNCTION UpperCase (S:String):String;                      { Capitalizes a string       }


FUNCTION Capitals (S:String):String;            { Capitalizes first letter of each word }


FUNCTION OutMany (S:String; N:INTEGER):String;             { Outputs N times a string S }


FUNCTION OutDate (D:Date):String;                   { Outputs date in the form dd/mm/yy }


FUNCTION DayInFull (D:INTEGER):STRING;              { Outputs the full name of the D-th }
                                                    { day of the week.                  }

FUNCTION DayInShort (D:INTEGER):STRING;


FUNCTION MonthInFull (M:INTEGER):String;                { The same as above, for months }


FUNCTION MonthLen (M:Byte):Word;


FUNCTION SCRN (X,Y:BYTE):WORD;                { Yields the ASCII code & color attribute }
                                              { of co-ordinates (X,Y).                  }

FUNCTION GetKey:WORD;               { Pauses for a key, checking for special edit keys. }


FUNCTION Compare_Dates (Date1,Date2:Date):SHORTINT;


FUNCTION Centre (S:String):String;              { Aligns string S to the middle of line }


PROCEDURE Toggle (VAR X:BOOLEAN);                          { Toggles a boolean variable }


PROCEDURE HideCursor;                                                { Hides the cursor }


PROCEDURE ShowCursor;                                        { Turns the cursor back on }


PROCEDURE SetAttr (X,Y,ATTR:BYTE);               { Changes the color attribute of (X,Y) }


PROCEDURE KeyClick;                                        { Produces a Key-Click sound }


PROCEDURE Bell;                                       { Produces a Bell (Warning) sound }


PROCEDURE PrintAt (X,Y:INTEGER; S:String; ATTR:BYTE);   { Access the Video RAM to print }
                                         { string S at (X,Y) using color attribute ATTR }

Function GetParam (S:String):Boolean;



IMPLEMENTATION                                        { of sub-programs mentioned above }

USES DOS,CRT;                                   { Link DOS and CRT units.               }



FUNCTION Max (A,B:LongInt):LongInt;

Begin
  If A>B Then Max:=A Else Max:=B;
End;


FUNCTION Min (A,B:LongInt):LongInt;

Begin
  If A<B Then Min:=A Else Min:=B;
End;



FUNCTION IToS (N:INTEGER):String;

VAR
  Temp:String;

BEGIN
  Str (N,Temp);
  IToS:=Temp;
END;



FUNCTION WToS (N:WORD):String;

VAR
  Temp:String;

BEGIN
  Str (N,Temp);
  WToS:=Temp;
END;



FUNCTION LToS (N:LONGINT):String;

VAR
  Temp:String;

BEGIN
  Str (N,Temp);
  LToS:=Temp;
END;



FUNCTION BToS (B:BYTE):String;

VAR
  Temp:String;

BEGIN
  Str (B,Temp);
  BToS:=Temp;
END;



FUNCTION SToW (S:String):Word;

Var
  Temp:Word;
  Err :Integer;

Begin
  Val (S,Temp,Err);
  SToW:=Temp;
End;



FUNCTION SToL (S:String):LongInt;

Var
  Temp:Real;
  Err :Integer;

Begin
  Val (S,Temp,Err);
  If (Temp>2147483647) Then Temp:=2147483647;
  If (Temp<-2147483647) Then Temp:=-2147483647;
  SToL:=Round (Temp);     
End;



FUNCTION GrUpCase (C:Char):Char;

Const
  UC:String [34]='';
  LC:String [34]='';

Begin
  If Pos (C,LC)<>0 Then GrUpCase:=UC [Pos (C,LC)] Else GrUpCase:=UpCase (C);
End;



FUNCTION LCase (C:Char):Char;

Const
  UC:String [70]='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  LC:String [70]='abcdefghijklmnopqrstuvwxyz';

Begin
  If Pos (C,UC)<>0 Then LCase:=LC [Pos (C,UC)] Else LCase:=C;
End;



FUNCTION UpperCase (S:String):String;

VAR
  Temp:String;
     I:INTEGER;

BEGIN
  Temp:=S;
  For I:=1 To Length(S) Do Temp [I]:=GrUpCase (S[I]);    { Use UpCase function on every }
  UpperCase:=Temp;                                       { character of S               }
END;



Function Capitals (S:String):String;
     
Const
  UC:String [60]='ABCDEFGHIJKLMNOPQRSTUVWXYZ'#39;
  LC:String [60]='abcdefghijklmnopqrstuvwxyz'#39;
  Letters:Set of Char=[#65..#90,#128..#151,#39];

Var
  I:Byte;
  C:Char;
  FirstLetter:Boolean;

Begin
  FirstLetter:=True;
  For I:=1 To Length (S) Do Begin
    C:=GrUpCase (S [I]);
    If C In Letters  Then Begin
      If FirstLetter Then C:=GrUpCase (C) Else Begin
        If C<>#39 Then Begin
          C:=LC [Pos (C,UC)];
          If S [I] In ['','','','','','','','',''] Then C:=S [I];
        End;
      End;
      If (C='') And (Not (GrUpCase (S [I+1]) In Letters))
       And (I<Length (S)) Then C:='';
      If (C='') And (I=Length (S)) Then C:='';
      FirstLetter:=False;
    End Else FirstLetter:=True;
    S [I]:=C;
  End;
  Capitals:=S;
End;



FUNCTION OutMany (S:String; N:INTEGER) :String;

VAR
  Temporary:String;
     Number:INTEGER;

BEGIN
  Temporary:='';
  For Number:=1 To N Do Temporary:=Temporary+S;         { Concatenates string S N times }
  OutMany:=Temporary;
END;




FUNCTION OutDate (D:Date):String;

VAR
  Conversion:String;
  Temp:String;
  I:Byte;

BEGIN
  With D Do BEGIN
    Str (DD:2,Conversion);
    Temp:=Conversion+'/';
    Str (MM:2,Conversion);
    Temp:=Temp+Conversion+'/';
    Str (YY:4,Conversion);
    Temp:=Temp+Conversion;
  END;
  For I:=1 To Length (Temp) Do If Temp [I]=' ' Then Temp [I]:='0';
  OutDate:=Temp;
END;




PROCEDURE Toggle (VAR X:BOOLEAN);

BEGIN
  X:=Not X;                                    { Toggles variable using boolean algebra }
END;




PROCEDURE SetCursorForm (X:WORD);        { Local procedure used in Hide- and ShowCursor }

VAR
  REG : Registers;                                  { Define a REGISTERS type variable. }

BEGIN
  With REG Do BEGIN
    AH := 1;                                              { select INT 10h function #01 }
    BH := 0;
    CX := X;                                 { Register CX contains the new cursor form }
    Intr ($10, REG);                                             { Invoke Interrupt 10h }
  END;
END;



PROCEDURE HideCursor;

BEGIN
  SetCursorForm ($FFFF);
END;



PROCEDURE ShowCursor;

BEGIN
  SetCursorForm ($0708);
END;



FUNCTION Compare_Dates (Date1,Date2:Date):SHORTINT;

VAR
  Temp:SHORTINT;

BEGIN
  Temp:=Date1.YY-Date2.YY;
  If Temp<>0 Then Compare_Dates:=Temp Div Abs (Temp) Else
   Compare_Dates:=Temp;

  If Temp=0 Then BEGIN
    Temp:=Date1.MM-Date2.MM;
    If Temp<>0 Then Compare_Dates:=Temp Div Abs (Temp) Else
     Compare_Dates:=Temp;

    If Temp=0 Then BEGIN
      Temp:=Date1.DD-Date2.DD;
      If Temp<>0 Then Compare_Dates:=Temp Div Abs (Temp) Else
        Compare_Dates:=Temp;
    END;
  END;
END;




FUNCTION DayInFull(D:INTEGER):String;

BEGIN
  Case D Of
    1:DayInFull:='Monday';
    2:DayInFull:='Tuesday';
    3:DayInFull:='Wednesday';
    4:DayInFull:='Thursday';
    5:DayInFull:='Friday';
    6:DayInFull:='Saturday';
    0:DayInFull:='Sunday';
  END;
END;





FUNCTION DayInShort (D:INTEGER):String;

BEGIN
  Case D Of
    1:DayInShort:='Mon';
    2:DayInShort:='Tue';
    3:DayInShort:='Wed';
    4:DayInShort:='Thu';
    5:DayInShort:='Fri';
    6:DayInShort:='Sat';
    0:DayInShort:='Sun';
  END;
END;





FUNCTION MonthInFull(M:INTEGER):String;

BEGIN
  Case M Of
    1:MonthInFull:='January';
    2:MonthInFull:='February';
    3:MonthInFull:='March';
    4:MonthInFull:='April';
    5:MonthInFull:='May';
    6:MonthInFull:='June';
    7:MonthInFull:='July';
    8:MonthInFull:='August';
    9:MonthInFull:='September';
   10:MonthInFull:='October';
   11:MonthInFull:='November';
   12:MonthInFull:='December';
  END;
END;



FUNCTION MonthLen (M:Byte):Word;

Begin
  MonthLen:=0;
  If M In [1,3,5,7,8,10,12] Then MonthLen:=31;
  If M In [4,6,9,11] Then MonthLen:=30;
  If M=2 Then MonthLen:=28;
End;



FUNCTION GetKey:WORD;                       { Special keys actually push 2 bytes to the }
                                            { keyboard queue: (i)  ASCII 00    &        }
VAR                                         {                 (ii) The key's scan code  }
  X:WORD;

BEGIN
  Repeat Until Keypressed;
  If KeyPressed Then X:=Ord(ReadKey) Else Begin
    GetKey:=$FFFE;
    Exit;
  End;
  If (X=0) And Keypressed Then BEGIN { If the ASCII code = 00, a special key is pressed }
    X:=Ord(ReadKey);                 { Get special key code                             }
    Inc (X,256);                     { GetKey adds 256 to all special key codes         }
  END;
  GetKey:=X;
  KeyClick;                   { Produce a keyclick sound to show a key has been pressed }
END;





FUNCTION SCRN (X,Y:BYTE):WORD;

VAR
  Seg,Off:WORD;                         { SEGment & OFFset in memory of character (X,Y) }

BEGIN
  If LastMode=MONO Then Seg:=$B000 Else Seg:=$B800;{ Determine the first address of the }
                                                   { Video-RAM according to display     }
                                                   { type                               }
  Off:=((Y-1)*Columns+(X-1))*2;                { Calculate offset of co-ordinates (X,Y) }
  SCRN:=MemW[Seg:Off];                         { Return the word at address SEG:OFF     }
END;





PROCEDURE SetAttr (X,Y,ATTR:BYTE);

VAR
  Seg,Off:WORD;

BEGIN
  If LastMode=MONO Then Seg:=$B000 Else Seg:=$B800;
  X:=Lo(WindMin)+X;
  Y:=Hi(WindMin)+Y;
  Off:=((Y-1)*Columns+(X-1))*2+1;
  MEM [Seg:Off]:=ATTR;                   { Change color attribute by directly accessing }
END;                                     { Video-RAM.                                   }





FUNCTION Centre (S:String):String;

BEGIN
  Centre:=OutMany (' ',((LO(WINDMAX)-LO(WINDMIN)+1)-LENGTH(S)) DIV 2-1)+S;
END;                          { Insert   (Length of Line - Length of S) : 2   spaces to }
                              { to the beginning of S                                   }





PROCEDURE KeyClick;

BEGIN
  Sound (KeyPr.Freq);                                            { Sound the FREQuency. }
  Delay (KeyPr.Dur);                                             { Wait for DURation    }
  NoSound;                                                       { Silence Loudspeaker  }
END;





PROCEDURE Bell;

BEGIN
  Sound (BellSnd.Freq);
  Delay (BellSnd.Dur);
  NoSound;
END;



PROCEDURE PrintAt (X,Y:INTEGER; S:String; ATTR:BYTE);

VAR
  Off,Seg:WORD;
  TempAttr:BYTE;

BEGIN
  X:=Lo(WindMin)+X;
  Y:=Hi(WindMin)+Y;
  If LastMode=MONO Then Seg:=$B000 Else Seg:=$B800;              { Determine segment of }
                                                                            { Video-ram }
  TempAttr:=TextAttr;                               { Store the current color attribute }
  TextAttr:=ATTR;
  Off:=((Y-1)*Columns*2)+((X-1)*2);               { Determine segment of location (X,Y) }
  For X:=1 To Length (S) Do BEGIN
    MemW [Seg:Off]:=Ord (S [X]) + ATTR*$100;                           { Print string S }
    Inc (Off,2);
  END;
  TextAttr:=TempAttr;
END;



Function GetParam (S:String):Boolean;     { Check if a certain command }
                                          { line parameter has been    }
Var I:Byte;                               { passed to the program.     }

Begin
  S:=UpperCase (S);
  GetParam:=False;
  For I:=1 To ParamCount Do
   If UpperCase (Copy (ParamStr (I),1,Length (S)))=S Then Begin
     GetParam:=True;
     Exit;
   End Else GetParam:=False;
End;



BEGIN                                                               { Initialise values }
  Columns:=80;                              { All screens have an 80 by 25 display mode }
  Rows:=25;

  BellSnd.Dur:=20;                                               { Define sound of Bell }
  BellSnd.Freq:=800;

  KeyPr.Dur:=1;                                             { Define sound of Key-Click }
  KeyPr.Freq:=1;
END.
